{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:14:15 $                                        =}
{========================================================================}
unit fmMain;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  Menus,
  MMMixCtl,
  MMMixer,
  MMObj,
  MMDesign,
  MMSpin,
  MMDevice,
  MMLEDLbl, ExtCtrls, MMHook;

type
  TMainForm = class(TForm)
    MMDesigner1: TMMDesigner;
    MMMixerDevice1: TMMMixerDevice;
    MMAudioLine1: TMMAudioLine;
    MMMixerControl1: TMMMixerControl;
    MMAudioLine2: TMMAudioLine;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    file1: TMenuItem;
    Dump1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    ListBox1: TListBox;
    ListBox2: TListBox;
    MMDeviceSpin1: TMMDeviceSpin;
    MMLEDLABEL1: TMMLEDLABEL;
    Panel3: TPanel;
    Bevel1: TBevel;
    Panel4: TPanel;
    MMMixerLabelConnector1: TMMMixerLabelConnector;
    procedure ListBox2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MMMixerDevice1Change(Sender: TObject);
    procedure Dump1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private

    procedure CreateParams(var Params: TCreateParams); override;

    procedure FillControls;
    procedure FillLines;
    procedure Dump(var F : TextFile) ;
  end;

var
  MainForm: TMainForm;

implementation

uses TypInfo;

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.CreateParams(var Params: TCreateParams);
begin
    inherited CreateParams(Params);
    Params.Style := Params.Style and not WS_SIZEBOX;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FillControls;
var
    i : Integer;
begin
   ListBox1.Clear;
   with ListBox1.Items do
   begin
      for i := 0 to MMAudioLine1.Controls - 1 do
      begin
         MMMixerControl1.ControlId := MMAudioLine1.Control[i];
         Add(MMMixerControl1.ControlInfo.Name);
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FillLines;
var
    i, j : Integer;
begin
   ListBox2.Clear;
   with ListBox2.Items do
   begin
      for i := 0 to MMMixerDevice1.Destinations - 1 do
      begin
         MMAudioLine1.LineId := MMMixerDevice1.Destination[i] ;
         AddObject('DST: ' + MMAudioLine1.LineInfo.Name,TObject(MMAudioLine1.LineId));
         for j := 0 to MMAudioLine1.Connections - 1 do
         begin
            MMAudioLine2.LineId := MMAudioLine1.Connection[j];
            AddObject('     ' + MMAudioLine2.LineInfo.Name,TObject(MMAudioLine2.LineId));
         end;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.ListBox2Click(Sender: TObject);
begin
   with ListBox2 do
   if ItemIndex <> -1 then
   begin
      MMAudioLine1.LineId := TMMLineId(Items.Objects[ItemIndex]);
      FillControls;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
   FillLines;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMMixerDevice1Change(Sender: TObject);
begin
   FillLines;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Dump(var F : TextFile) ;
var
    i   : Integer ;
    j   : Integer ;
    k   : Integer ;
    Dst : string ;
begin
   Writeln(F,'*** Mixer device');
   with MMMixerDevice1 do
   begin
      Writeln(F,'Destinations: ',Destinations);
      Writeln(F,'Product name: ',DeviceCaps.ProductName);
      Writeln(F,'Device count: ',DeviceCount);
   end;
   FillLines ;
   Writeln(F,'*** Lines' );
   for i := 0 to ListBox2.Items.Count do
   begin
      ListBox2.ItemIndex := i ;
      ListBox2Click(ListBox2);
      with MMAudioLine1 do
      begin
         if cfSource in LineInfo.Flags then
            Dst := 'SRC'
         else
            Dst := 'DST' ;
         Writeln(F,'*** ',Dst,' ',LineInfo.Name);
         Writeln(F,'ComponentType: ',GetEnumName(TypeInfo(TMMComponentType),Ord(ComponentType)));
         Writeln(F,'LineId: ',LineId);
         Writeln(F,'Channels: ',LineInfo.Channels);
         Writeln(F,'Connections:',LineInfo.Connections);
         Writeln(F,'Controls: ',LineInfo.Controls);
         if cfActive in LineInfo.Flags then
            Write(F,'Active ');
         if cfDisconnected in LineInfo.Flags then
            Write(F,'Disconnected ');
         if cfSource in LineInfo.Flags then
            Write(F,'Source ');
         Writeln(F);
      end;
      for j := 0 to MMAudioLine1.Controls - 1 do
      begin
         MMMixerControl1.ControlId := MMAudioLine1.Control[j];
         with MMMixerControl1 do
         begin
            Writeln(F,'--- ', ControlInfo.Name);
            Writeln(F,'Control class: ',GetEnumName(TypeInfo(TMMControlClass),Ord(ControlClass)));
            Writeln(F,'Control id: ',ControlId);
            if cfDisabled in ControlInfo.Flags then
               Write(F,'Disabled ');
            if cfMultiple in ControlInfo.Flags then
               Write(F,'Multiple ');
            if cfUniform in ControlInfo.Flags then
               Write(F,'Uniform ');
            Writeln(F);
            Writeln(F,'MinValue: ', ControlInfo.MinValue);
            Writeln(F,'MaxValue: ', ControlInfo.MaxValue);
            Writeln(F,'MultipleItems: ', ControlInfo.MultipleItems);
            Writeln(F,'Steps: ', ControlInfo.Steps);
            Writeln(F,'Control type: ',GetEnumName(TypeInfo(TMMControlType),Ord(ControlType)));
            if cfMultiple in ControlInfo.Flags then
            for k := 0 to Items - 1 do
                Writeln(F, 'Item: ', ItemInfo[k].Name, ' (', ItemInfo[k].Val1, ',', ItemInfo[k].Val2, ')');
         end;
      end;
   end;
   Writeln(F,'*** Done');
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Dump1Click(Sender: TObject);
var
    F : TextFile ;
begin
   if SaveDialog1.Execute then
   begin
      AssignFile(F,SaveDialog1.FileName);
      Rewrite(F);
      try
         Dump(F);
      finally
         CloseFile(F);
      end
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Exit1Click(Sender: TObject);
begin
   Close;
end;

end.
